
(* 5x5 flyways - up to 10 xbots with the example application design loaded on the PMC as design 1 *)
FUNCTION_BLOCK Example37_ApplicationDesigner
	//5x5 flyways, up to 10 xbots - example application design loaded on the PMC as design 1

	IF NOT Execute THEN
		XbotIndex := 0;
	END_IF;
	
	//start the system
	Reboot(Execute := Execute,PM_Controller := PMC);
	ActivatePMC(Execute := Reboot.Done,PM_Controller := PMC);

	//move xbots to starting positions
	ReadXbotIDs(Enable := ActivatePMC.Done,PM_Controller := PMC);
	FOR i := 0 TO 9 DO
		Home.XbotID[i] := INT_TO_USINT(i + 1);
		Home.PosX[i] := 0.06 + 0.12*i;
		Home.PosY[i] := 0.06;
	END_FOR;
	Home(Execute := ReadXbotIDs.Valid,nXbots := ReadXbotIDs.NumXbots,PM_Controller := PMC);
	SendToStart(Execute := Home.Done,XbotID := XbotIndex + 1,StationID := 1,BayID := 1,PM_Controller := PMC);
	IF SendToStart.Ack AND XbotIndex + 1 < ReadXbotIDs.NumXbots THEN
		XbotIndex := XbotIndex + 1;
		SendToStart(Execute := FALSE,PM_Controller := PMC);
	END_IF;

	//station 1 bay 1
	HoldForXbot_Station1Bay1(Execute := SendToStart.Ack,StationID := 1,BayID := 1,PM_Controller := PMC);
	SelectNextBay_Station1Bay1(Execute := HoldForXbot_Station1Bay1.Done,Seed := 11);
	SendToNextBay_Station1Bay1(Execute := HoldForXbot_Station1Bay1.Done,XbotID := HoldForXbot_Station1Bay1.XbotID,StationID := 2,BayID := UDINT_TO_USINT(SelectNextBay_Station1Bay1.RandomNumber MOD 2) + 1,PM_Controller := PMC);
	IF SendToNextBay_Station1Bay1.Ack THEN
		HoldForXbot_Station1Bay1(Execute := FALSE,PM_Controller := PMC);
		SelectNextBay_Station1Bay1(Execute := FALSE);
		SendToNextBay_Station1Bay1(Execute := FALSE,PM_Controller := PMC);
	END_IF;

	//station 1 bay 2
	HoldForXbot_Station1Bay2(Execute := SendToStart.Ack,StationID := 1,BayID := 2,PM_Controller := PMC);
	SelectNextBay_Station1Bay2(Execute := HoldForXbot_Station1Bay2.Done,Seed := 12);
	SendToNextBay_Station1Bay2(Execute := HoldForXbot_Station1Bay2.Done,XbotID := HoldForXbot_Station1Bay2.XbotID,StationID := 2,BayID := UDINT_TO_USINT(SelectNextBay_Station1Bay2.RandomNumber MOD 2) + 1,PM_Controller := PMC);
	IF SendToNextBay_Station1Bay2.Ack THEN
		HoldForXbot_Station1Bay2(Execute := FALSE,PM_Controller := PMC);
		SelectNextBay_Station1Bay2(Execute := FALSE);
		SendToNextBay_Station1Bay2(Execute := FALSE,PM_Controller := PMC);
	END_IF;

	//station 2 bay 1
	HoldForXbot_Station2Bay1(Execute := SendToStart.Ack,StationID := 2,BayID := 1,PM_Controller := PMC);
	SelectNextBay_Station2Bay1(Execute := HoldForXbot_Station2Bay1.Done,Seed := 21);
	SendToNextBay_Station2Bay1(Execute := HoldForXbot_Station2Bay1.Done,XbotID := HoldForXbot_Station2Bay1.XbotID,StationID := 1,BayID := UDINT_TO_USINT(SelectNextBay_Station2Bay1.RandomNumber MOD 2) + 1,PM_Controller := PMC);
	IF SendToNextBay_Station2Bay1.Ack THEN
		HoldForXbot_Station2Bay1(Execute := FALSE,PM_Controller := PMC);
		SelectNextBay_Station2Bay1(Execute := FALSE);
		SendToNextBay_Station2Bay1(Execute := FALSE,PM_Controller := PMC);
	END_IF;

	//station 2 bay 2
	HoldForXbot_Station2Bay2(Execute := SendToStart.Ack,StationID := 2,BayID := 2,PM_Controller := PMC);
	SelectNextBay_Station2Bay2(Execute := HoldForXbot_Station2Bay2.Done,Seed := 22);
	SendToNextBay_Station2Bay2(Execute := HoldForXbot_Station2Bay2.Done,XbotID := HoldForXbot_Station2Bay2.XbotID,StationID := 1,BayID := UDINT_TO_USINT(SelectNextBay_Station2Bay2.RandomNumber MOD 2) + 1,PM_Controller := PMC);
	IF SendToNextBay_Station2Bay2.Ack THEN
		HoldForXbot_Station2Bay2(Execute := FALSE,PM_Controller := PMC);
		SelectNextBay_Station2Bay2(Execute := FALSE);
		SendToNextBay_Station2Bay2(Execute := FALSE,PM_Controller := PMC);
	END_IF;
END_FUNCTION_BLOCK
